import java.io.IOException;
import java.util.ArrayList;

public class CreditCardCompany extends FinancialInstitution {

	private static int numCCCos = 1;
	private String name         = new String();
	private double assets;
	private double minNetWorth  = 1000;
	private double cut          = .02;

	/** Creates a new instance of CreditCardCompany with name n, assets a **/
	public CreditCardCompany(String n, double a) {
		super();
		++numCCCos;
		name = n;
		assets = a;
		
	}
	
	/** Creates a new instance of CreditCardCompany with name "CreditCardCo#" and assets a **/
	public CreditCardCompany( double a ) {
		this ("CreditCardCo" + numCCCos, a);
	}
	
	/** Creates a new instance of CreditCardCompany with name "CreditCardCo#" and assets 1000000 **/
	public CreditCardCompany() {
		this("CreditCardCo" + numCCCos, 1000000);
	}
	
	/** Creates a new credit card account for person owner and returns the account *
	 * @throws IOException */
	public CreditCardAccount applyForCard(Person owner) throws IOException {
		// check password
		if (!owner.requestPassword()) {
			return null;
		}
		
		// check if he has enough money to get a credit card
		if (owner.getNetWorth() < minNetWorth) {
			System.out.println("Your credit card application has been rejected because your net worth is too low.");
			return null;
		}
		
		CreditCardAccount cc = new CreditCardAccount(owner, this);
		ArrayList accounts  = getAccounts();
		ArrayList customers = getCustomers();
		
		// add to accounts array
		accounts.add(cc);
		
		// check if this is a new customer for the bank and add them to the customer array if they are
		if (customers.indexOf(owner) == -1)
			customers.add(owner);
		
		return cc;
		
	}
	
	/** Cancels the credit card account *
	 * @throws IOException */
	public boolean cancelCard(CreditCardAccount ac) throws IOException {
		Person owner = ac.getOwner();
		
		if (! owner.requestPassword()) {
			return false;
		}
		
		ArrayList<Account> accounts  = getAccounts();
		ArrayList<Person> customers = getCustomers();
		
		// remove from accounts array
		accounts.remove(ac);
		
		// check if the customer has any more accounts at this bank
		boolean stillCust = false;
		for (int i = 0; i<accounts.size(); ++i) {
			if (accounts.get(i).getOwner().equals(owner)) {
				stillCust = true;
				break;
			}
		}
		if (!stillCust)
			customers.remove(owner);
		
		return true;
	}
	
	/** = the cut this company takes for each credit card transaction **/
	public double getCut() {
		return cut;
	}
	
	/** sets the cut the company takes for each credit card transaction **/
	public void setCut(double c) {
		cut = c;
	}
	
	/** = the company's assets **/
	public double getAssets() {
		return assets;
	}
	
	/** sets the company's assets **/
	public void setAssets(double a) {
		assets = a;
	}
	
	/** = the company's name **/
	public String getName() {
		return name;
	}
	
	/** sets the company's name **/
	public void setName(String n) {
		name= n;
	}
	
	/** = the minimum net worth a person can have that this company will allow them to take out a credit card **/
	public double getMinNetWorth() {
		return minNetWorth;
	}
	
	/** sets the minimum net worth a person can have that this company will allow them to take out a credit card **/
	public void setminNetWorth(double m) {
		minNetWorth = m;
	}

}
